/*!---------------------------------------------------------
 * Copyright (C) Microsoft Corporation. All rights reserved.
 *--------------------------------------------------------*/
import { ParsedPath } from "path";
export declare const WATSON_LINE_BREAK: string;
export interface OSPath {
    normalize(p: string): string;
    join(...paths: any[]): string;
    resolve(...pathSegments: any[]): string;
    isAbsolute(p: string): boolean;
    relative(from: string, to: string): string;
    dirname(p: string): string;
    basename(p: string, ext?: string): string;
    extname(p: string): string;
    sep: string;
    delimiter: string;
    parse(p: string): ParsedPath;
    format(pP: ParsedPath): string;
}
export declare enum pathMode {
    windows = 0,
    posix = 1,
    defaultMode = 2,
}
/**
 * converts a path to a posix style one (no drive letters, forward slashes)
 * for example, we would make the following transformation:
 * C:\users\person\desktop\file.xml
 * would become
 * /c/users/person/desktop/file.xml
 */
export declare function convertPathToPosix(input: string): string;
/**
 * converts a posix style path to Windows style (drive letter, backslashes)
 * if it is an absolute path and the root folder is a single letter, this will become the drive letter
 * if it is absolute and does not have a suitable root folder, it will use A.
 */
export declare function convertPathToWindows(input: string): string;
/**
 * Replaces all instances of a string in another string with the given string.
 */
export declare function replaceAll(input: string, find: string, replace: string): string;
export declare function convertVersion(input: string): string;
